/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.element.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TextWindowElement
extends AnimatedOverlayElement {
    Supplier<String> textGetter = () -> "(?) No text was provided";
    String bakedText;
    int y;
    class_243 vec;
    boolean nearScene = false;
    int color = PonderPalette.WHITE.getColor();

    @Override
    protected void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        class_241 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new class_241((float)(screen.field_22789 / 2), (float)((screen.field_22790 - 200) / 2 + this.y - 8));
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.field_1342) : sceneToScreen.field_1342;
        float yDiff = ((float)screen.field_22790 / 2.0f - sceneToScreen.field_1342 - 10.0f) / 100.0f;
        float targetX = (float)screen.field_22789 * class_3532.method_16439((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.field_1343 + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.field_22789 - targetX, 180.0f);
        List lines = screen.getFontRenderer().method_27527().method_27498(this.bakedText, textWidth, class_2583.field_24360);
        int boxWidth = 0;
        for (class_5348 line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().method_27525(line));
        }
        int boxHeight = screen.getFontRenderer().method_1713(this.bakedText, boxWidth);
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(0.0f, pY, 400.0f);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.TEXT_WINDOW_BORDER))).at(targetX - 10.0f, 3.0f, 100.0f)).withBounds(boxWidth, boxHeight - 1)).render(graphics);
        int brighterColor = Color.mixColors(this.color, -35, 0.5f);
        brighterColor = 0xFFFFFF & brighterColor | 0xFF000000;
        if (this.vec != null) {
            ms.method_22903();
            ms.method_46416(sceneToScreen.field_1343, 0.0f, 0.0f);
            double lineTarget = (targetX - sceneToScreen.field_1343) * fade;
            ms.method_22905((float)lineTarget, 1.0f, 1.0f);
            graphics.method_33284(0, 0, 1, 1, -100, brighterColor, brighterColor);
            graphics.method_33284(0, 1, 1, 2, -100, -11974327, -13027015);
            ms.method_22909();
        }
        ms.method_46416(0.0f, 0.0f, 400.0f);
        for (int i = 0; i < lines.size(); ++i) {
            graphics.method_51433(screen.getFontRenderer(), ((class_5348)lines.get(i)).getString(), (int)(targetX - 10.0f), 3 + 9 * i, new Color(brighterColor).scaleAlpha(fade).getRGB(), false);
        }
        ms.method_22909();
    }

    public int getColor() {
        return this.color;
    }

    public class Builder {
        private PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        public Builder colored(PonderPalette color) {
            TextWindowElement.this.color = color.getColor();
            return this;
        }

        public Builder pointAt(class_243 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        public Builder independent() {
            return this.independent(0);
        }

        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        public Builder sharedText(class_2960 key) {
            TextWindowElement.this.textGetter = () -> PonderLocalization.getShared(key);
            return this;
        }

        public Builder sharedText(String key) {
            return this.sharedText(new class_2960(this.scene.getNamespace(), key));
        }

        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

